<?php

namespace App\Controllers;

use App\Core\Controller;
use App\Core\Database;
use App\Models\Product;

class MenuController extends Controller
{
    public function index()
    {
        $productModel = new Product();
        $products = $productModel->getAll();
        
        // Agrupar por categoria
        $menu = [];
        foreach ($products as $p) {
            $cat = $p['category_name'] ?? 'Outros';
            $menu[$cat][] = $p;
        }

        $db = Database::getInstance()->getConnection();
        $deliveryZones = $db->query("SELECT * FROM delivery_zones WHERE active = 1 ORDER BY neighborhood ASC")->fetchAll();

        $this->view('client.home', ['menu' => $menu, 'deliveryZones' => $deliveryZones]);
    }

    public function show($slug)
    {
        $productModel = new Product();
        $product = $productModel->getBySlug($slug);

        if (!$product) {
            $this->redirect('/');
        }

        $this->view('client.product', ['product' => $product]);
    }
}
