<?php
require 'app/Core/Database.php';

$db = App\Core\Database::getInstance()->getConnection();

echo "Creating users table...\n";

$sql = "CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(100) NOT NULL,
    username VARCHAR(50) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    role ENUM('admin', 'employee') DEFAULT 'employee',
    permissions TEXT NULL, -- SQLite/MySQL compability (using TEXT for JSON)
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
)";

$db->exec($sql);

// Check if admin exists
$stmt = $db->query("SELECT * FROM users WHERE username = 'admin'");
if (!$stmt->fetch()) {
    echo "Creating default admin user...\n";
    $pass = password_hash('123456', PASSWORD_DEFAULT);
    $stmt = $db->prepare("INSERT INTO users (name, username, password, role, permissions) VALUES (?, ?, ?, ?, ?)");
    $stmt->execute(['Administrador', 'admin', $pass, 'admin', json_encode(['all'])]);
} else {
    echo "Admin user already exists.\n";
}

echo "Done.\n";
