<?php include __DIR__ . '/../layout/header.php'; ?>

<div class="container" style="margin-top: 20px;">
    <h2>🛵 Taxas de Entrega por Bairro</h2>
    
    <div class="card" style="margin-bottom: 20px;">
        <h3>Adicionar/Editar Bairro</h3>
        <form action="/admin/delivery/save" method="POST" style="display: flex; gap: 10px; align-items: flex-end;">
            <input type="hidden" name="id" id="edit-id">
            <div style="flex: 2;">
                <label>Bairro</label>
                <input type="text" name="neighborhood" id="edit-neighborhood" required style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
            </div>
            <div style="flex: 1;">
                <label>Taxa (R$)</label>
                <input type="text" name="fee" id="edit-fee" required placeholder="0,00" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
            </div>
            <button type="submit" class="btn" style="background: #28a745; color: white; padding: 10px 20px;">Salvar</button>
            <button type="button" onclick="resetForm()" class="btn" style="background: #6c757d; color: white; padding: 10px 20px;">Limpar</button>
        </form>
    </div>

    <div class="card">
        <table style="width: 100%; border-collapse: collapse;">
            <thead>
                <tr style="background: #f0f0f0;">
                    <th style="padding: 10px; text-align: left;">Bairro</th>
                    <th style="padding: 10px; text-align: left;">Taxa de Entrega</th>
                    <th style="padding: 10px; text-align: right;">Ações</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($zones as $zone): ?>
                    <tr style="border-bottom: 1px solid #eee;">
                        <td style="padding: 10px;"><?= htmlspecialchars($zone['neighborhood']) ?></td>
                        <td style="padding: 10px;">R$ <?= number_format($zone['fee'], 2, ',', '.') ?></td>
                        <td style="padding: 10px; text-align: right;">
                            <button onclick='editZone(<?= json_encode($zone) ?>)' class="btn" style="padding: 5px 10px; background: #007bff; color: white; border: none; cursor: pointer;">Editar</button>
                            <form action="/admin/delivery/<?= $zone['id'] ?>/delete" method="POST" style="display: inline-block;" onsubmit="return confirm('Remover este bairro?');">
                                <button type="submit" class="btn" style="padding: 5px 10px; background: #dc3545; color: white;">Excluir</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<script>
function editZone(zone) {
    document.getElementById('edit-id').value = zone.id;
    document.getElementById('edit-neighborhood').value = zone.neighborhood;
    document.getElementById('edit-fee').value = parseFloat(zone.fee).toFixed(2).replace('.', ',');
}

function resetForm() {
    document.getElementById('edit-id').value = '';
    document.getElementById('edit-neighborhood').value = '';
    document.getElementById('edit-fee').value = '';
}
</script>

<?php include __DIR__ . '/../layout/footer.php'; ?>
