<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Lista de Compras</title>
    <style>
        body { font-family: 'Courier New', monospace; font-size: 12px; margin: 0; padding: 5px; width: 58mm; max-width: 58mm; }
        h2 { text-align: center; font-size: 14px; margin-bottom: 5px; border-bottom: 1px dashed #000; padding-bottom: 5px; }
        .item { margin-bottom: 5px; border-bottom: 1px dotted #ccc; padding-bottom: 2px; }
        .item-name { display: block; font-weight: bold; }
        .item-qty { display: block; text-align: right; }
        .footer { margin-top: 15px; text-align: center; font-size: 10px; border-top: 1px dashed #000; padding-top: 5px; }
        @media print {
            .no-print { display: none; }
            body { width: 100%; margin: 0; padding: 0; }
        }
    </style>
</head>
<body onload="window.print()">
    <div class="no-print" style="margin-bottom: 10px; text-align: center;">
        <button onclick="window.print()">Imprimir</button>
        <button onclick="window.close()">Fechar</button>
    </div>

    <h2>LISTA DE COMPRAS</h2>
    <p style="text-align: center; margin: 0 0 10px 0; font-size: 10px;">Gerado em: <?= date('d/m/Y H:i') ?></p>

    <?php if (empty($missing)): ?>
        <p style="text-align: center;">Nenhum item em falta!</p>
    <?php else: ?>
        <?php foreach ($missing as $item): ?>
            <div class="item">
                <span class="item-name"><?= htmlspecialchars($item['name']) ?></span>
                <span class="item-qty">
                    Qtd Atual: <?= floatval($item['stock_quantity']) ?> <?= $item['unit'] ?>
                    <br>
                    Min: <?= floatval($item['min_threshold']) ?>
                </span>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>

    <div class="footer">
        OSiriCascudo System<br>
        Gestão Inteligente
    </div>
</body>
</html>