<?php include __DIR__ . '/../layout/header.php'; ?>

<div class="container" style="margin-top: 20px;">
    <h2>💰 Vendas por Dia</h2>
    
    <div class="card" style="margin-bottom: 20px;">
        <form method="GET" action="/admin/vendas-dia" style="display: flex; align-items: center; gap: 10px; flex-wrap: wrap;">
            <div>
                <label for="date">Selecione a data:</label>
                <input 
                    type="date" 
                    id="date" 
                    name="date" 
                    value="<?= htmlspecialchars($selectedDate ?? date('Y-m-d')) ?>"
                    max="<?= date('Y-m-d') ?>"
                    style="padding: 6px 10px; border-radius: 4px; border: 1px solid #ccc;"
                >
            </div>
            <button type="submit" class="btn">Ver vendas</button>
            <a href="/admin/vendas-dia" class="btn" style="background: #607D8B; color: white;">Hoje</a>
        </form>
    </div>

    <div class="card" style="text-align: center; padding: 40px;">
        <h3>Total vendido em <?= date('d/m/Y', strtotime($selectedDate ?? date('Y-m-d'))) ?></h3>
        <p style="font-size: 3rem; color: var(--primary); font-weight: 800; margin: 10px 0;">
            R$ <?= number_format($totalSales, 2, ',', '.') ?>
        </p>
    </div>

    <div class="card">
        <h3>Detalhamento por Pagamento</h3>
        <table style="width: 100%; border-collapse: collapse;">
            <thead>
                <tr style="background: #f0f0f0;">
                    <th style="padding: 10px; text-align: left;">Método</th>
                    <th style="padding: 10px; text-align: center;">Qtd. Pedidos</th>
                    <th style="padding: 10px; text-align: right;">Total</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($salesByMethod as $sale): ?>
                    <tr style="border-bottom: 1px solid #eee;">
                        <td style="padding: 10px;"><?= htmlspecialchars($sale['payment_method']) ?></td>
                        <td style="padding: 10px; text-align: center;"><?= $sale['count'] ?></td>
                        <td style="padding: 10px; text-align: right;">R$ <?= number_format($sale['total'], 2, ',', '.') ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>
