<?php include __DIR__ . '/../layout/header.php'; ?>

<div class="container" style="margin-top: 20px;">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
        <h2>📦 Controle de Estoque</h2>
        <div style="display: flex; gap: 10px;">
            <button onclick="document.getElementById('addForm').style.display = document.getElementById('addForm').style.display === 'none' ? 'block' : 'none'" class="btn" style="background: #2196F3; color: white;">+ Novo Item</button>
            <a href="/admin/estoque/imprimir" target="_blank" class="btn" style="background: #607D8B; color: white;">🖨️ Imprimir Lista de Compras</a>
        </div>
    </div>

    <!-- Add Form -->
    <div id="addForm" style="display:none; background: #fff; padding: 20px; border: 1px solid #ddd; margin-bottom: 20px; border-radius: 8px; box-shadow: 0 2px 5px rgba(0,0,0,0.1);">
        <h3 style="margin-top: 0;">Adicionar Novo Ingrediente</h3>
        <form action="/admin/estoque/adicionar" method="POST" style="display: flex; gap: 15px; flex-wrap: wrap; align-items: flex-end;">
            <div style="flex: 2; min-width: 200px;">
                <label style="display: block; margin-bottom: 5px;">Nome do Item</label>
                <input type="text" name="name" required placeholder="Ex: Pão de Hambúrguer" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
            </div>
            <div style="flex: 1; min-width: 100px;">
                <label style="display: block; margin-bottom: 5px;">Unidade</label>
                <select name="unit" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
                    <option value="un">Unidade (un)</option>
                    <option value="kg">Quilos (kg)</option>
                    <option value="l">Litros (l)</option>
                    <option value="g">Gramas (g)</option>
                    <option value="ml">Mililitros (ml)</option>
                    <option value="fatia">Fatia</option>
                    <option value="maço">Maço</option>
                </select>
            </div>
            <div style="flex: 1; min-width: 100px;">
                <label style="display: block; margin-bottom: 5px;">Qtd Inicial</label>
                <input type="text" name="stock_quantity" value="0" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
            </div>
            <div style="flex: 1; min-width: 100px;">
                <label style="display: block; margin-bottom: 5px;">Alerta Mínimo</label>
                <input type="text" name="min_threshold" value="10" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
            </div>
            <button type="submit" class="btn" style="background: #4CAF50; color: white; height: 38px;">Adicionar</button>
        </form>
    </div>
    
    <div class="card">
        <form action="/admin/estoque/critico" method="POST">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
                <h3>Ingredientes e Alertas</h3>
                <button type="submit" class="btn" style="background: #FF9800; color: white;">💾 Salvar Alterações de Estoque</button>
            </div>
            
            <table style="width: 100%; border-collapse: collapse;">
                <thead>
                    <tr style="background: #f0f0f0;">
                        <th style="padding: 10px; text-align: left;">Ingrediente</th>
                        <th style="padding: 10px; width: 150px; text-align: center;">Estoque Atual</th>
                        <th style="padding: 10px; width: 150px; text-align: center;">Estoque Mínimo</th>
                        <th style="padding: 10px; text-align: center;">Status</th>
                        <th style="padding: 10px; width: 50px;">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($ingredients as $ing): ?>
                        <tr style="border-bottom: 1px solid #eee;">
                            <td style="padding: 10px;"><?= htmlspecialchars($ing['name']) ?></td>
                            <td style="padding: 10px;">
                                <div style="display: flex; align-items: center; gap: 5px; justify-content: center;">
                                    <input 
                                        type="text" 
                                        name="stock_quantity[<?= $ing['id'] ?>]" 
                                        value="<?= number_format($ing['stock_quantity'], 3, ',', '.') ?>" 
                                        style="width: 80px; padding: 5px; border: 1px solid #ddd; border-radius: 4px; text-align: right;"
                                    >
                                    <small><?= $ing['unit'] ?></small>
                                </div>
                            </td>
                            <td style="padding: 10px;">
                                <div style="display: flex; align-items: center; gap: 5px; justify-content: center;">
                                    <input 
                                        type="text" 
                                        name="min_threshold[<?= $ing['id'] ?>]" 
                                        value="<?= number_format($ing['min_threshold'] ?? 10, 3, ',', '.') ?>" 
                                        style="width: 80px; padding: 5px; border: 1px solid #ddd; border-radius: 4px; text-align: right;"
                                    >
                                    <small><?= $ing['unit'] ?></small>
                                </div>
                            </td>
                            <td style="padding: 10px; text-align: center;">
                                <?php if ($ing['stock_quantity'] <= ($ing['min_threshold'] ?? 10)): ?>
                                    <span style="color: #f44336; font-weight: bold; display: inline-flex; align-items: center; gap: 5px;">
                                        ⚠️ BAIXO
                                    </span>
                                <?php else: ?>
                                    <span style="color: #4CAF50; font-weight: bold;">OK</span>
                                <?php endif; ?>
                            </td>
                            <td style="padding: 10px;">
                                <button type="submit" form="delete-form-<?= $ing['id'] ?>" class="btn" style="background: transparent; color: #f44336; padding: 5px;" title="Excluir">🗑️</button>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </form>
        
        <?php foreach ($ingredients as $ing): ?>
            <form id="delete-form-<?= $ing['id'] ?>" action="/admin/estoque/<?= $ing['id'] ?>/excluir" method="POST" onsubmit="return confirm('Tem certeza que deseja excluir <?= htmlspecialchars($ing['name']) ?>?');" style="display: none;"></form>
        <?php endforeach; ?>

    </div>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>
