<?php include __DIR__ . '/../../layout/header.php'; ?>
<div class="container" style="margin-top: 20px;">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
        <h2>👥 Gerenciar Funcionários</h2>
        <a href="<?= $baseUrl ?>/admin/usuarios/novo" class="btn">Adicionar Novo</a>
    </div>
    <div class="card">
        <table style="width: 100%; border-collapse: collapse;">
            <thead>
                <tr style="background: #f0f0f0;">
                    <th style="padding: 10px; text-align: left;">Nome</th>
                    <th style="padding: 10px; text-align: left;">Usuário</th>
                    <th style="padding: 10px; text-align: center;">Função</th>
                    <th style="padding: 10px; text-align: center;">Permissões</th>
                    <th style="padding: 10px; text-align: center;">Ações</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($users as $u): ?>
                    <tr style="border-bottom: 1px solid #eee;">
                        <td style="padding: 10px;"><?= htmlspecialchars($u['name']) ?></td>
                        <td style="padding: 10px;"><?= htmlspecialchars($u['username']) ?></td>
                        <td style="padding: 10px; text-align: center;">
                            <span style="padding: 3px 8px; border-radius: 4px; background: <?= $u['role'] == 'admin' ? '#2196F3' : '#4CAF50' ?>; color: white; font-size: 0.8rem;">
                                <?= $u['role'] == 'admin' ? 'Administrador' : 'Funcionário' ?>
                            </span>
                        </td>
                        <td style="padding: 10px; text-align: center; font-size: 0.8rem; color: #666;">
                            <?php 
                                if ($u['role'] == 'admin') {
                                    echo "Todas";
                                } else {
                                    $perms = json_decode($u['permissions'] ?? '[]', true);
                                    if (empty($perms)) echo "Apenas Cozinha";
                                    else {
                                        $labels = [
                                            'dashboard' => 'Dashboard',
                                            'stock' => 'Estoque',
                                            'menu' => 'Cardápio',
                                            'sales' => 'Vendas'
                                        ];
                                        $display = [];
                                        foreach ($perms as $p) if (isset($labels[$p])) $display[] = $labels[$p];
                                        echo implode(', ', $display);
                                    }
                                }
                            ?>
                        </td>
                        <td style="padding: 10px; text-align: center;">
                            <a href="<?= $baseUrl ?>/admin/usuarios/<?= $u['id'] ?>/editar" class="btn" style="padding: 5px 10px; font-size: 0.8rem; background: #FF9800; color: white; margin-right: 4px;">Editar</a>
                            <?php if ($u['id'] != $_SESSION['user_id']): ?>
                                <form action="/admin/usuarios/<?= $u['id'] ?>/excluir" method="POST" style="display: inline-block;" onsubmit="return confirm('Tem certeza?');">
                                    <button type="submit" class="btn" style="padding: 5px 10px; font-size: 0.8rem; background: #f44336; color: white;">Excluir</button>
                                </form>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
<?php include __DIR__ . '/../../layout/footer.php'; ?>