<!-- Modal Interstitial (Após adicionar ao carrinho) -->
<div class="product-modal-backdrop" id="interstitial-modal">
    <div class="product-modal" style="text-align: center; padding: 30px;">
        <h3 style="margin-bottom: 20px;">Item adicionado! 😋</h3>
        <p style="margin-bottom: 30px;">O que deseja fazer agora?</p>
        
        <div style="display: flex; flex-direction: column; gap: 10px;">
            <button type="button" class="btn" onclick="closeInterstitial()" style="background: #fff; color: #333; border: 1px solid #ccc;">
                Continuar pedindo
            </button>
            <a href="/checkout" class="btn" style="background: #28a745; color: white;">
                Finalizar pedido
            </a>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const neighborhoodSelect = document.getElementById('neighborhood-select');
    const deliveryFeeInput = document.querySelector('input[name="delivery_fee"]');
    const deliveryFeeText = document.querySelector('[data-cart-delivery-text]');
    const totalText = document.querySelector('[data-cart-total-text]');
    const cartSubtotalEl = document.querySelector('.card.cart-summary-card');
    
    if (neighborhoodSelect) {
        neighborhoodSelect.addEventListener('change', function() {
            const selectedOption = this.options[this.selectedIndex];
            const fee = parseFloat(selectedOption.getAttribute('data-fee') || 0);
            
            // Atualiza input hidden
            if (deliveryFeeInput) deliveryFeeInput.value = fee.toFixed(2);
            
            // Atualiza texto visual
            if (deliveryFeeText) deliveryFeeText.innerText = 'R$ ' + fee.toFixed(2).replace('.', ',');
            
            // Atualiza total
            const subtotal = parseFloat(cartSubtotalEl.getAttribute('data-cart-subtotal') || 0);
            const total = subtotal + fee;
            if (totalText) totalText.innerText = 'R$ ' + total.toFixed(2).replace('.', ',');
        });
    }

    // Intercept Add to Cart Form
    const productForm = document.querySelector('#product-modal form');
    if (productForm) {
        productForm.addEventListener('submit', function(e) {
            e.preventDefault();
            
            const formData = new FormData(this);
            
            fetch('/carrinho/add', {
                method: 'POST',
                body: formData
            })
            .then(response => {
                // Se redirecionar, assumimos sucesso, mas aqui queremos ficar na página
                // O controller redireciona, então o fetch segue o redirect e retorna a página HTML do destino.
                // Idealmente o controller deveria retornar JSON se pedido via AJAX.
                // Mas vamos apenas recarregar a página ou mostrar o modal se assumirmos sucesso.
                // Como o PHP redireciona, o 'response.url' mudou.
                
                // Vamos mostrar o modal interstitial
                document.getElementById('product-modal').classList.remove('active');
                document.getElementById('interstitial-modal').classList.add('active');
            })
            .catch(err => {
                console.error(err);
                alert('Erro ao adicionar produto.');
            });
        });
    }
});

function closeInterstitial() {
    document.getElementById('interstitial-modal').classList.remove('active');
    window.location.reload(); // Recarrega para atualizar o carrinho na sidebar
}
</script>
