<?php include __DIR__ . '/../layout/header.php'; ?>

<div class="container" style="margin-top: 20px;">
    <div class="card">
        <a href="/" style="color: #666; text-decoration: none;">&larr; Voltar para o Cardápio</a>
        
        <div style="display: flex; flex-wrap: wrap; gap: 30px; margin-top: 20px;">
            <div style="flex: 1; min-width: 300px;">
                <?php 
                    $imgUrl = $product['image_url'];
                    if ($imgUrl && strpos($imgUrl, 'http') !== 0) {
                        $imgUrl = $baseUrl . '/' . ltrim($imgUrl, '/');
                    }
                    $displayImg = $imgUrl ?: 'https://placehold.co/600x400?text=Siri+Cascudo';
                ?>
                <img src="<?= $displayImg ?>" style="width: 100%; border-radius: 10px;" alt="<?= htmlspecialchars($product['name']) ?>" onerror="this.src='https://placehold.co/600x400?text=Imagem+Indispon%C3%ADvel'">
            </div>
            
            <div style="flex: 1; min-width: 300px;">
                <h1 style="color: var(--accent);"><?= htmlspecialchars($product['name']) ?></h1>
                <p style="font-size: 1.2rem;"><?= htmlspecialchars($product['description']) ?></p>
                <span class="price" style="font-size: 2rem;">R$ <?= number_format($product['base_price'], 2, ',', '.') ?></span>

                <form action="/carrinho/add" method="POST" style="margin-top: 20px;">
                    <input type="hidden" name="product_id" value="<?= $product['id'] ?>">
                    <input type="hidden" name="name" value="<?= $product['name'] ?>">
                    <input type="hidden" name="price" value="<?= $product['base_price'] ?>">

                    <?php if (!empty($product['options'])): ?>
                        <h3>Turbine seu pedido (O Pulo do Gato)</h3>
                        <?php foreach ($product['options'] as $opt): ?>
                            <div style="margin-bottom: 10px;">
                                <label>
                                    <input type="checkbox" name="options[]" value="<?= $opt['id'] ?>">
                                    <?= htmlspecialchars($opt['name']) ?> 
                                    (+ R$ <?= number_format($opt['additional_price'], 2, ',', '.') ?>)
                                </label>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>

                    <div style="margin-top: 20px;">
                        <label style="font-weight: bold;">Observações (ex: Sem cebola, capricha no molho):</label>
                        <textarea name="notes" rows="3" style="width: 100%; padding: 10px; border-radius: 5px; border: 1px solid #ccc;"></textarea>
                    </div>

                    <div style="margin-top: 20px; display: flex; gap: 10px; align-items: center;">
                        <label>Quantidade:</label>
                        <input type="number" name="quantity" value="1" min="1" style="width: 60px; padding: 10px; font-size: 1.2rem;">
                        <button type="submit" class="btn" style="flex: 1;">Adicionar ao Carrinho</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>
