<?php include __DIR__ . '/../layout/header.php'; ?>

<div class="container" style="margin-top: 20px; text-align: center;">
    <div class="card">
        <h2>Rastreio do Pedido #<?= $order['id'] ?></h2>
        
        <div style="margin: 40px 0;">
            <?php
                $steps = ['pending' => 'Recebido', 'preparing' => 'Preparando', 'ready' => 'Pronto', 'delivery' => 'Saiu para Entrega', 'completed' => 'Entregue'];
                $currentFound = false;
            ?>
            
            <div style="display: flex; justify-content: space-between; position: relative;">
                <!-- Linha de progresso -->
                <div style="position: absolute; top: 15px; left: 0; width: 100%; height: 5px; background: #eee; z-index: 1;"></div>
                
                <?php foreach ($steps as $key => $label): ?>
                    <?php 
                        $active = ($key == $order['status']);
                        if ($active) $currentFound = true;
                        $past = !$currentFound && !$active; 
                        $color = ($active || $past) ? 'var(--primary)' : '#ccc';
                    ?>
                    <div style="position: relative; z-index: 2; text-align: center; flex: 1;">
                        <div style="width: 30px; height: 30px; background: <?= $color ?>; border-radius: 50%; margin: 0 auto; line-height: 30px; color: white; font-weight: bold;">
                            <?= ($past || $active) ? '✓' : '' ?>
                        </div>
                        <p style="margin-top: 10px; color: <?= $color ?>; font-weight: bold;"><?= $label ?></p>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        <?php
            $statusLabels = [
                'pending' => 'Recebido',
                'preparing' => 'Preparando',
                'ready' => 'Pronto',
                'delivery' => 'Saiu para Entrega',
                'completed' => 'Entregue',
            ];
            $currentLabel = $statusLabels[$order['status']] ?? strtoupper($order['status']);
        ?>
        <p>Status Atual: <strong><?= $currentLabel ?></strong></p>
        <button onclick="window.location.reload()" class="btn">Atualizar Status</button>
    </div>
</div>

<?php if (!empty($_GET['print'])): ?>
<script>
window.addEventListener('load', function() {
    window.print();
});
</script>
<?php endif; ?>

<?php include __DIR__ . '/../layout/footer.php'; ?>
