    <div class="mobile-nav">
        <a href="/">🏠 Cardápio</a>
        <a href="/carrinho">🛒 Carrinho</a>
        <a href="/rastreio/ultimo">🛵 Pedidos</a>
    </div>

    <script>
        (function () {
            var cartCard = document.querySelector('.cart-summary-card');
            if (cartCard) {
                var header = cartCard.querySelector('[data-toggle="delivery-calc"]');
                var panel = cartCard.querySelector('.delivery-panel');
                var deliveryButtons = cartCard.querySelectorAll('[data-mode-select]');
                var modeInput = cartCard.querySelector('input[name="mode"]');
                var deliverySection = cartCard.querySelector('[data-mode="delivery"]');
                var pickupSection = cartCard.querySelector('[data-mode="pickup"]');
                var feeDisplay = cartCard.querySelector('[data-cart-delivery-text]');
                var feeInput = cartCard.querySelector('input[name="delivery_fee"]');
                var totalDisplay = cartCard.querySelector('[data-cart-total-text]');
                var subtotalValue = parseFloat(cartCard.getAttribute('data-cart-subtotal') || '0');
                var form = cartCard.querySelector('.cart-delivery-form');

                var neighborhoodFees = {
                    "Centro": 5.00,
                    "Bairro 1": 8.00,
                    "Bairro 2": 10.00
                };

                function formatMoney(value) {
                    return value.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' });
                }

                function updateTotals() {
                    var fee = parseFloat(feeInput.value || '0');
                    if (isNaN(fee)) fee = 0;
                    var total = subtotalValue + fee;
                    if (feeDisplay) {
                        feeDisplay.textContent = formatMoney(fee);
                    }
                    if (totalDisplay) {
                        totalDisplay.textContent = formatMoney(total);
                    }
                }

                if (header && panel) {
                    header.addEventListener('click', function () {
                        panel.style.display = panel.style.display === 'block' ? 'none' : 'block';
                    });
                }

                deliveryButtons.forEach(function (btn) {
                    btn.addEventListener('click', function () {
                        var mode = btn.getAttribute('data-mode-select');
                        deliveryButtons.forEach(function (b) { b.classList.remove('active'); });
                        btn.classList.add('active');
                        if (modeInput) modeInput.value = mode;
                        if (mode === 'delivery') {
                            if (deliverySection) deliverySection.style.display = '';
                            if (pickupSection) pickupSection.style.display = 'none';
                        } else {
                            if (deliverySection) deliverySection.style.display = 'none';
                            if (pickupSection) pickupSection.style.display = '';
                            if (feeInput) feeInput.value = '0';
                            updateTotals();
                        }
                    });
                });

                var neighborhoodSelect = cartCard.querySelector('select[name="neighborhood"]');
                if (neighborhoodSelect) {
                    neighborhoodSelect.addEventListener('change', function () {
                        var bairro = neighborhoodSelect.value;
                        var fee = neighborhoodFees[bairro] || 0;
                        if (feeInput) {
                            feeInput.value = fee.toFixed(2);
                        }
                        updateTotals();
                    });
                }

                updateTotals();

                if (form) {
                    form.addEventListener('submit', function (e) {
                        e.preventDefault();
                        var xhr = new XMLHttpRequest();
                        xhr.open('POST', form.getAttribute('action'), true);
                        xhr.onload = function () {
                            if (xhr.status >= 200 && xhr.status < 300) {
                                updateTotals();
                            }
                        };
                        xhr.send(new FormData(form));
                    });
                }
            }

            var modalBackdrop = document.getElementById('product-modal');
            if (modalBackdrop) {
                var nameEl = modalBackdrop.querySelector('[data-modal-name]');
                var descEl = modalBackdrop.querySelector('[data-modal-description]');
                var totalEl = modalBackdrop.querySelector('[data-modal-total]');
                var form = modalBackdrop.querySelector('form');
                var qtyInput = modalBackdrop.querySelector('input[name="quantity"]');
                var priceInput = modalBackdrop.querySelector('input[name="price"]');
                var productIdInput = modalBackdrop.querySelector('input[name="product_id"]');
                var productNameInput = modalBackdrop.querySelector('input[name="name"]');
                var optionInputs = modalBackdrop.querySelectorAll('input[name="options[]"]');
                var basePrice = 0;

                function recalcModalTotal() {
                    var qty = parseInt(qtyInput.value || '1', 10);
                    if (isNaN(qty) || qty < 1) qty = 1;
                    qtyInput.value = qty;
                    var extras = 0;
                    optionInputs.forEach(function (opt) {
                        if (opt.checked) {
                            var parts = opt.value.split(':');
                            var price = parseFloat(parts[2] || '0');
                            if (!isNaN(price)) extras += price;
                        }
                    });
                    var unit = basePrice + extras;
                    var total = unit * qty;
                    if (totalEl) {
                        totalEl.textContent = total.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' });
                    }
                }

                document.querySelectorAll('[data-open-product]').forEach(function (btn) {
                    btn.addEventListener('click', function () {
                        optionInputs.forEach(function (opt) { opt.checked = false; });
                        qtyInput.value = 1;

                        var name = btn.getAttribute('data-name') || '';
                        var desc = btn.getAttribute('data-description') || '';
                        var price = parseFloat(btn.getAttribute('data-price') || '0');
                        var id = btn.getAttribute('data-id') || '';

                        basePrice = isNaN(price) ? 0 : price;

                        if (nameEl) nameEl.textContent = name;
                        if (descEl) descEl.textContent = desc;
                        if (priceInput) priceInput.value = basePrice.toFixed(2);
                        if (productIdInput) productIdInput.value = id;
                        if (productNameInput) productNameInput.value = name;

                        recalcModalTotal();

                        modalBackdrop.classList.add('active');
                    });
                });

                if (qtyInput) {
                    qtyInput.addEventListener('input', recalcModalTotal);
                }
                optionInputs.forEach(function (opt) {
                    opt.addEventListener('change', recalcModalTotal);
                });

                modalBackdrop.addEventListener('click', function (e) {
                    if (e.target === modalBackdrop) {
                        modalBackdrop.classList.remove('active');
                    }
                });
                var closeBtn = modalBackdrop.querySelector('[data-modal-close]');
                if (closeBtn) {
                    closeBtn.addEventListener('click', function () {
                        modalBackdrop.classList.remove('active');
                    });
                }
            }
        })();
    </script>
</body>
</html>
