<?php
$baseUrl = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\');
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>OSiriCascudo - O Melhor Hambúrguer do Fundo do Mar</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;800&family=Space+Grotesk:wght@400;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #FF9900; /* Amarelo Bob */
            --secondary: #00A8E8; /* Azul Fundo do Mar */
            --accent: #8B4513; /* Marrom Madeira Siri Cascudo */
            --text: #333;
            --light: #fff;
        }
        body {
            font-family: 'Poppins', sans-serif;
            background-color: var(--secondary);
            background-image: url('https://upload.wikimedia.org/wikipedia/commons/thumb/8/8c/SpongeBob_SquarePants_logo.svg/1200px-SpongeBob_SquarePants_logo.svg.png'); /* Exemplo placeholder */
            background-image: linear-gradient(to bottom, #00A8E8, #0077BE);
            color: var(--text);
            margin: 0;
            padding: 0;
            padding-bottom: 80px; /* Espaço pro footer mobile */
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        header {
            background: var(--accent);
            color: white;
            padding: 8px 0 14px 0;
            text-align: center;
            box-shadow: 0 4px 10px rgba(0,0,0,0.3);
            border-bottom: 5px solid var(--primary);
        }
        .logo-main {
            max-width: 240px;
            width: 35%;
            height: auto;
            display: block;
            margin: 0 auto 2px auto;
            filter: drop-shadow(0 6px 12px rgba(0,0,0,0.6));
        }
        header h1 {
            font-family: 'Poppins', sans-serif;
            margin: 0 0 2px 0;
            font-size: 1.9rem;
            font-weight: 800;
            text-transform: uppercase;
            letter-spacing: 1px;
            color: #ffffff;
            text-shadow: 0 2px 0 #000;
        }
        header p {
            margin: 0;
            font-family: 'Poppins', sans-serif;
            font-size: 0.95rem;
            font-weight: 400;
        }
        .nav-bar {
            display: flex;
            justify-content: center;
            gap: 20px;
            margin-top: 10px;
        }
        .nav-bar a {
            color: white;
            text-decoration: none;
            font-weight: bold;
            font-size: 1.1rem;
        }
        .card {
            background: white;
            border-radius: 15px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            border: 2px solid var(--accent);
        }
        .btn {
            display: inline-block;
            background: var(--primary);
            color: var(--accent);
            padding: 10px 20px;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 800;
            text-transform: uppercase;
            border: none;
            cursor: pointer;
            transition: transform 0.2s;
        }
        .btn:hover {
            transform: scale(1.05);
            background: #ffaa33;
        }
        .product-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
            gap: 20px;
        }
        .product-card {
            background: white;
            border-radius: 10px;
            overflow: hidden;
            text-align: center;
            border: 2px solid #ddd;
        }
        .product-card img {
            width: 100%;
            height: 200px;
            object-fit: cover;
            background: #eee;
        }
        .product-card .info {
            padding: 15px;
        }
        .price {
            font-size: 1.4rem;
            color: var(--accent);
            font-weight: bold;
            display: block;
            margin: 10px 0;
        }
        /* Mobile Footer Nav */
        .mobile-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            width: 100%;
            background: white;
            display: flex;
            justify-content: space-around;
            padding: 15px 0;
            box-shadow: 0 -2px 10px rgba(0,0,0,0.1);
            z-index: 1000;
        }
        .mobile-nav a {
            text-decoration: none;
            color: var(--accent);
            font-weight: bold;
            display: flex;
            flex-direction: column;
            align-items: center;
            font-size: 0.9rem;
        }
        .top-nav {
            background: #ffffff;
            border-bottom: 1px solid #eee;
        }
        .top-nav-inner {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        .top-nav-logo {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            object-fit: cover;
        }
        .top-nav-search {
            flex: 1;
            display: flex;
            align-items: center;
            background: #f5f5f5;
            border-radius: 999px;
            padding: 4px 10px;
        }
        .top-nav-search input {
            border: none;
            background: transparent;
            width: 100%;
            padding: 4px 6px;
            outline: none;
            font-family: 'Poppins', sans-serif;
        }
        .top-nav-links {
            display: flex;
            align-items: center;
            gap: 18px;
            font-size: 0.9rem;
        }
        .top-nav-links a {
            color: #666;
            text-decoration: none;
            font-family: 'Poppins', sans-serif;
            display: flex;
            align-items: center;
            gap: 4px;
        }
        .top-nav-links a.active {
            color: #0000aa;
            font-weight: 600;
        }
        .layout-with-cart {
            display: flex;
            align-items: flex-start;
            gap: 20px;
        }
        .layout-main {
            flex: 1;
            min-width: 0;
        }
        .cart-sidebar {
            width: 320px;
            flex-shrink: 0;
        }
        .cart-summary-card {
            padding: 0;
            border-radius: 12px;
            overflow: hidden;
        }
        .cart-summary-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 14px 16px;
            border-bottom: 1px solid #eee;
            cursor: pointer;
            font-size: 0.95rem;
        }
        .cart-summary-header span:nth-child(1) {
            display: flex;
            align-items: center;
            gap: 8px;
        }
        .cart-summary-header-icon {
            font-size: 1.1rem;
        }
        .cart-summary-body {
            padding: 16px;
        }
        .cart-empty {
            text-align: center;
            color: #999;
            padding: 35px 10px;
            font-size: 0.95rem;
        }
        .cart-empty-icon {
            font-size: 2.5rem;
            margin-bottom: 8px;
        }
        .cart-totals {
            border-top: 1px solid #eee;
            padding: 12px 16px 16px 16px;
            font-size: 0.9rem;
        }
        .cart-totals-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 4px;
        }
        .cart-totals-row.cart-total {
            margin-top: 8px;
            font-weight: 700;
            font-size: 1rem;
        }
        .cart-coupon {
            border-top: 1px solid #eee;
            padding: 12px 16px;
            font-size: 0.85rem;
            color: #555;
        }
        .cart-coupon a {
            color: #555;
            text-decoration: none;
        }
        .cart-summary-footer {
            padding: 12px 16px 16px 16px;
        }
        .cart-summary-footer .btn {
            width: 100%;
            text-align: center;
            border-radius: 8px;
            background: #5a54d6;
            color: #fff;
        }
        .cart-summary-footer .btn.disabled {
            background: #ccc;
            cursor: not-allowed;
        }
        .delivery-panel {
            display: none;
            padding: 16px;
            border-top: 1px solid #eee;
            background: #fafafa;
            font-size: 0.9rem;
        }
        .delivery-panel-section {
            margin-bottom: 12px;
        }
        .delivery-panel label {
            display: block;
            margin-bottom: 4px;
            font-weight: 600;
            font-size: 0.85rem;
        }
        .delivery-panel input[type="text"],
        .delivery-panel textarea,
        .delivery-panel select {
            width: 100%;
            padding: 8px;
            border-radius: 6px;
            border: 1px solid #ddd;
            font-family: 'Poppins', sans-serif;
            font-size: 0.85rem;
        }
        .delivery-mode-options {
            display: flex;
            gap: 8px;
            margin-bottom: 8px;
        }
        .delivery-mode-options button {
            flex: 1;
            padding: 8px;
            border-radius: 999px;
            border: 1px solid #ddd;
            background: #fff;
            font-size: 0.85rem;
            cursor: pointer;
        }
        .delivery-mode-options button.active {
            border-color: var(--primary);
            background: #fff7e6;
        }
        .delivery-panel small {
            font-size: 0.75rem;
            color: #777;
        }
        .product-modal-backdrop {
            position: fixed;
            inset: 0;
            background: rgba(0,0,0,0.55);
            display: none;
            align-items: center;
            justify-content: center;
            z-index: 2001;
        }
        .product-modal-backdrop.active {
            display: flex;
        }
        .product-modal {
            background: #fff;
            border-radius: 16px;
            max-width: 420px;
            width: 90%;
            max-height: 90vh;
            overflow-y: auto;
            box-shadow: 0 10px 30px rgba(0,0,0,0.35);
        }
        .product-modal-header {
            padding: 14px 16px 0 16px;
        }
        .product-modal-header h3 {
            margin: 0;
            color: var(--accent);
        }
        .product-modal-body {
            padding: 8px 16px 16px 16px;
            font-size: 0.9rem;
        }
        .product-modal-footer {
            padding: 12px 16px 16px 16px;
            border-top: 1px solid #eee;
        }
        .product-modal-footer .btn {
            width: 100%;
            text-align: center;
        }
        .product-modal-close {
            position: absolute;
            top: 8px;
            right: 12px;
            background: transparent;
            border: none;
            font-size: 1.2rem;
            cursor: pointer;
        }
        .product-modal-price-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 8px;
            font-weight: 600;
        }
        .product-modal-qty {
            display: flex;
            align-items: center;
            gap: 8px;
            margin-top: 12px;
        }
        .product-modal-qty input {
            width: 70px;
            padding: 8px;
            font-size: 1rem;
            text-align: center;
        }
        .product-modal-extras-group {
            margin-top: 10px;
        }
        .product-modal-extras-group label {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 6px;
            font-size: 0.85rem;
        }
        .product-modal-extras-group span {
            color: var(--accent);
            font-weight: 600;
        }
        @media (max-width: 900px) {
            .layout-with-cart {
                flex-direction: column;
            }
            .cart-sidebar {
                display: none;
            }
            .mobile-only-block {
                display: block;
            }
            .desktop-only-block {
                display: none;
            }
        }
        @media (min-width: 901px) {
            .mobile-only-block {
                display: none;
            }
            .desktop-only-block {
                display: block;
            }
        }
    </style>
</head>
<body>
    <div class="top-nav">
        <div class="container top-nav-inner">
            <img src="<?= $baseUrl ?>/assets/img/logosiricascudo.png" alt="OSiriCascudo" class="top-nav-logo">
            <form class="top-nav-search" action="<?= $baseUrl ?>/" method="get">
                <span style="font-size: 0.9rem; color: #777;">🔍</span>
                <input type="text" name="q" placeholder="Buscar no cardápio" value="<?= isset($_GET['q']) ? htmlspecialchars($_GET['q']) : '' ?>">
            </form>
            <div class="top-nav-links">
                <a href="<?= $baseUrl ?>/" class="<?= $_SERVER['REQUEST_URI'] === '/' ? 'active' : '' ?>">🏠 Início</a>
                <a href="<?= $baseUrl ?>/checkout">🛒 Sacola</a>
                <a href="<?= $baseUrl ?>/rastreio/ultimo">🧾 Pedidos</a>
                <?php if (!empty($_SESSION['admin_logged_in'])): ?>
                    <a href="<?= $baseUrl ?>/admin">Dashboard</a>
                    <?php if (($_SESSION['user_role'] ?? '') === 'admin'): ?>
                        <a href="<?= $baseUrl ?>/admin/usuarios">Usuários</a>
                    <?php endif; ?>
                    <a href="<?= $baseUrl ?>/admin/tickets">Tickets diários</a>
                    <?php if (($_SESSION['user_role'] ?? '') === 'admin' || in_array('sales', $_SESSION['user_permissions'] ?? [])): ?>
                        <a href="<?= $baseUrl ?>/admin/vendas-dia">Vendas do dia</a>
                    <?php endif; ?>
                    <?php if (($_SESSION['user_role'] ?? '') === 'admin' || in_array('menu', $_SESSION['user_permissions'] ?? [])): ?>
                        <a href="<?= $baseUrl ?>/admin/cardapio">Cardápio</a>
                    <?php endif; ?>
                    <?php if (($_SESSION['user_role'] ?? '') === 'admin' || in_array('stock', $_SESSION['user_permissions'] ?? [])): ?>
                        <a href="<?= $baseUrl ?>/admin/estoque">Estoque</a>
                    <?php endif; ?>
                    <a href="<?= $baseUrl ?>/cozinha">Cozinha</a>
                    <a href="<?= $baseUrl ?>/admin/cashback">Cashback</a>
                    <a href="<?= $baseUrl ?>/logout">Sair</a>
                <?php else: ?>
                    <a href="<?= $baseUrl ?>/login">🔐 Login</a>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <header>
        <div class="container">
            <img src="<?= $baseUrl ?>/assets/img/logosiricascudo.png" alt="OSiriCascudo" class="logo-main">
            <h1>OSiriCascudo</h1>
            <p>O hambúrguer mais famoso da Fenda do Biquíni</p>
        </div>
    </header>
